@extends('admin.layouts.app')

@section('title', 'View Setting')
@section('page-title', 'View Setting')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-cog me-2"></i>
                    Setting Details
                </h5>
                <div>
                    <a href="{{ route('admin.settings.edit', $setting) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit me-1"></i>Edit
                    </a>
                    <form action="{{ route('admin.settings.destroy', $setting) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this setting?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger btn-sm">
                            <i class="fas fa-trash me-1"></i>Delete
                        </button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-8">
                        <table class="table table-borderless">
                            <tr>
                                <th width="200">ID:</th>
                                <td>{{ $setting->id }}</td>
                            </tr>
                            <tr>
                                <th>Key:</th>
                                <td><code>{{ $setting->key }}</code></td>
                            </tr>
                            <tr>
                                <th>Label:</th>
                                <td>{{ $setting->label }}</td>
                            </tr>
                            <tr>
                                <th>Type:</th>
                                <td>
                                    <span class="badge bg-info">{{ ucfirst($setting->type) }}</span>
                                </td>
                            </tr>
                            <tr>
                                <th>Value:</th>
                                <td>
                                    @if($setting->type === 'image' && $setting->value)
                                        <div class="mb-2">
                                            <img src="{{ Storage::url($setting->value) }}" 
                                                 alt="{{ $setting->label }}" 
                                                 class="img-thumbnail" 
                                                 style="max-width: 200px; max-height: 150px;">
                                        </div>
                                        <small class="text-muted">{{ $setting->value }}</small>
                                    @elseif($setting->type === 'textarea')
                                        <div class="border p-3 bg-light rounded">
                                            {!! nl2br(e($setting->value)) !!}
                                        </div>
                                    @elseif($setting->type === 'url' && $setting->value)
                                        <a href="{{ $setting->value }}" target="_blank" class="text-primary">
                                            {{ $setting->value }}
                                            <i class="fas fa-external-link-alt ms-1"></i>
                                        </a>
                                    @elseif($setting->type === 'email' && $setting->value)
                                        <a href="mailto:{{ $setting->value }}" class="text-primary">
                                            {{ $setting->value }}
                                        </a>
                                    @else
                                        {{ $setting->value ?: 'Not set' }}
                                    @endif
                                </td>
                            </tr>
                            @if($setting->description)
                            <tr>
                                <th>Description:</th>
                                <td>{{ $setting->description }}</td>
                            </tr>
                            @endif
                            <tr>
                                <th>Created At:</th>
                                <td>{{ $setting->created_at->format('M d, Y h:i A') }}</td>
                            </tr>
                            <tr>
                                <th>Updated At:</th>
                                <td>{{ $setting->updated_at->format('M d, Y h:i A') }}</td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-4">
                        <div class="text-center">
                            <div class="mb-3">
                                @if($setting->type === 'image')
                                    <i class="fas fa-image fa-5x text-success"></i>
                                @elseif($setting->type === 'textarea')
                                    <i class="fas fa-align-left fa-5x text-info"></i>
                                @elseif($setting->type === 'email')
                                    <i class="fas fa-envelope fa-5x text-warning"></i>
                                @elseif($setting->type === 'url')
                                    <i class="fas fa-link fa-5x text-primary"></i>
                                @elseif($setting->type === 'phone')
                                    <i class="fas fa-phone fa-5x text-success"></i>
                                @else
                                    <i class="fas fa-cog fa-5x text-secondary"></i>
                                @endif
                            </div>
                            <h6>{{ ucfirst($setting->type) }} Setting</h6>
                            <p class="text-muted">{{ $setting->label }}</p>
                            
                            @if($setting->type === 'image' && $setting->value)
                                <div class="mt-3">
                                    <a href="{{ Storage::url($setting->value) }}" 
                                       target="_blank" 
                                       class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-eye me-1"></i>View Full Size
                                    </a>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4">
                    <a href="{{ route('admin.settings.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-left me-2"></i>Back to List
                    </a>
                    <a href="{{ route('admin.settings.edit', $setting) }}" class="btn btn-primary">
                        <i class="fas fa-edit me-2"></i>Edit Setting
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

