@extends('admin.layouts.app')

@section('title', 'Specialties Management')
@section('page-title', 'Specialties Management')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">
                    <i class="fas fa-star me-2"></i>
                    Specialties List
                </h5>
                <a href="{{ route('admin.specialties.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add New Specialty
                </a>
            </div>
            <div class="card-body">
                @if($specialties->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Status</th>
                                    <th>Image</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($specialties as $specialty)
                                <tr>
                                    <td>{{ $specialty->id }}</td>
                                    <td>{{ Str::limit($specialty->title, 30) }}</td>
                                    <td>{{ Str::limit($specialty->description, 50) }}</td>
                                    <td>
                                        @if($specialty->is_active)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-secondary">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($specialty->image)
                                            <img src="{{ $specialty->image_url }}" alt="Image" class="img-thumbnail" style="width: 50px; height: 50px; object-fit: cover;">
                                        @else
                                            <span class="text-muted">No Image</span>
                                        @endif
                                    </td>
                                    <td>{{ $specialty->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('admin.specialties.show', $specialty) }}" class="btn btn-sm btn-outline-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('admin.specialties.edit', $specialty) }}" class="btn btn-sm btn-outline-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('admin.specialties.destroy', $specialty) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this specialty?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-center">
                        {{ $specialties->links() }}
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-star fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No specialties found</h5>
                        <p class="text-muted">Start by adding your first specialty.</p>
                        <a href="{{ route('admin.specialties.create') }}" class="btn btn-primary">
                            <i class="fas fa-plus me-2"></i>Add Specialty
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection

